#ifndef QRFECRC_H
#define QRFECRC_H

#include <QtGlobal>
#include <QByteArray>

class QrfeCRC
{
public:
	/*!
	 * @brief Simple function to calculate XOR checksum for a byte array
	 * @returns The calculated XOR checksum
	 */
    static quint8 calcXORCS(QByteArray data);

    /*!
     * @brief Function to calculate CRC16-CCITT checksum for a byte array
     * @returns The calculated CRC16 checksum
     */
    static quint16 calcCRC16(QByteArray data);

	/*!
	 * @brief Function to calculate Md5 hash for a byte array
	 * @returns The calculated Md5 hash
	 */
    static QByteArray   calcMD5(QByteArray data);
};

#endif // QRFECRC_H
